/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viafabricplus.features.networking.armor_hud;

import com.viaversion.viafabricplus.ViaFabricPlusImpl;
import com.viaversion.viafabricplus.protocoltranslator.ProtocolTranslator;
import com.viaversion.viafabricplus.settings.impl.DebugSettings;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.protocol.packet.PacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.Types;
import com.viaversion.viaversion.protocols.v1_8to1_9.Protocol1_8To1_9;
import com.viaversion.viaversion.protocols.v1_8to1_9.data.ArmorTypes1_8;
import com.viaversion.viaversion.protocols.v1_8to1_9.packet.ClientboundPackets1_9;
import java.util.UUID;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_1304;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_7923;

public final class ArmorHudEmulation1_8 {
    private static final UUID ARMOR_POINTS_UUID = UUID.fromString("2AD3F246-FEE1-4E67-B886-69FD380BB150");
    private static final class_1304[] ARMOR_SLOTS = new class_1304[]{class_1304.field_6169, class_1304.field_6174, class_1304.field_6172, class_1304.field_6166};
    private static double previousArmorPoints = 0.0;

    public static void init() {
        ClientTickEvents.START_WORLD_TICK.register(world -> {
            if (!DebugSettings.INSTANCE.emulateArmorHud.isEnabled()) {
                return;
            }
            if (class_310.method_1551().field_1724 != null) {
                UserConnection connection = ProtocolTranslator.getPlayNetworkUserConnection();
                if (connection != null) {
                    try {
                        ArmorHudEmulation1_8.sendArmorUpdate(connection);
                    }
                    catch (Throwable t) {
                        ViaFabricPlusImpl.INSTANCE.getLogger().error("Error sending armor update", t);
                    }
                }
            } else {
                previousArmorPoints = 0.0;
            }
        });
    }

    private static void sendArmorUpdate(UserConnection connection) {
        int armor = 0;
        for (class_1304 slot : ARMOR_SLOTS) {
            class_1799 stack = class_310.method_1551().field_1724.method_31548().field_56552.method_66659(slot);
            if (stack.method_7960()) continue;
            String identifier = class_7923.field_41178.method_10221((Object)stack.method_7909()).toString();
            armor += ArmorTypes1_8.findByType((String)identifier).getArmorPoints();
        }
        if ((double)armor == previousArmorPoints) {
            return;
        }
        previousArmorPoints = armor;
        PacketWrapper updateAttributes = PacketWrapper.create((PacketType)ClientboundPackets1_9.UPDATE_ATTRIBUTES, (UserConnection)connection);
        updateAttributes.write((Type)Types.VAR_INT, (Object)class_310.method_1551().field_1724.method_5628());
        updateAttributes.write((Type)Types.INT, (Object)1);
        updateAttributes.write(Types.STRING, (Object)"generic.armor");
        updateAttributes.write((Type)Types.DOUBLE, (Object)0.0);
        updateAttributes.write((Type)Types.VAR_INT, (Object)1);
        updateAttributes.write(Types.UUID, (Object)ARMOR_POINTS_UUID);
        updateAttributes.write((Type)Types.DOUBLE, (Object)armor);
        updateAttributes.write((Type)Types.BYTE, (Object)0);
        updateAttributes.scheduleSend(Protocol1_8To1_9.class);
    }
}

