/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viafabricplus.features.item.filter_creative_tabs;

import com.viaversion.viafabricplus.features.classic.cpe_extension.CPEAdditions;
import com.viaversion.viafabricplus.injection.access.base.IClientConnection;
import com.viaversion.viafabricplus.protocoltranslator.ProtocolTranslator;
import com.viaversion.viafabricplus.protocoltranslator.impl.ViaFabricPlusMappingDataLoader;
import com.viaversion.vialoader.util.VersionRange;
import com.viaversion.viaversion.api.protocol.version.ProtocolVersion;
import com.viaversion.viaversion.libs.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Objects;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1844;
import net.minecraft.class_1887;
import net.minecraft.class_2378;
import net.minecraft.class_2582;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_634;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9304;
import net.minecraft.class_9307;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.raphimc.vialegacy.api.LegacyProtocolVersion;
import net.raphimc.vialegacy.protocol.classic.c0_30cpetoc0_28_30.data.ClassicProtocolExtension;
import net.raphimc.vialegacy.protocol.classic.c0_30cpetoc0_28_30.storage.ExtensionProtocolMetadataStorage;

public final class VersionedRegistries {
    public static final Reference2ObjectMap<class_5321<class_1887>, VersionRange> ENCHANTMENT_DIFF = new Reference2ObjectOpenHashMap();
    public static final Reference2ObjectMap<class_5321<class_2582>, VersionRange> PATTERN_DIFF = new Reference2ObjectOpenHashMap();
    public static final Reference2ObjectMap<class_6880<class_1291>, VersionRange> EFFECT_DIFF = new Reference2ObjectOpenHashMap();
    public static final Reference2ObjectMap<class_1792, VersionRange> ITEM_DIFF = new Reference2ObjectOpenHashMap();

    public static void init() {
        JsonObject data = ViaFabricPlusMappingDataLoader.INSTANCE.loadData("versioned-registries.json");
        VersionedRegistries.fillKeys(data.getAsJsonObject("enchantments"), class_7924.field_41265, ENCHANTMENT_DIFF);
        VersionedRegistries.fillKeys(data.getAsJsonObject("banner_patterns"), class_7924.field_41252, PATTERN_DIFF);
        VersionedRegistries.fillEntries(data.getAsJsonObject("effects"), class_7923.field_41174, EFFECT_DIFF);
        VersionedRegistries.fillItems(data.getAsJsonObject("items"));
    }

    private static void fillKeys(JsonObject object, class_5321 registryKey, Reference2ObjectMap map) {
        for (String element : object.keySet()) {
            VersionRange versions = VersionRange.fromString((String)object.get(element).getAsString());
            class_5321 key = class_5321.method_29179((class_5321)registryKey, (class_2960)class_2960.method_60654((String)element));
            map.put((Object)key, (Object)versions);
        }
    }

    private static void fillEntries(JsonObject object, class_2378<?> registry, Reference2ObjectMap map) {
        for (String element : object.keySet()) {
            VersionRange versions = VersionRange.fromString((String)object.get(element).getAsString());
            class_6880 entry = (class_6880)registry.method_10223(class_2960.method_60654((String)element)).orElseThrow();
            map.put((Object)entry, (Object)versions);
        }
    }

    private static void fillItems(JsonObject object) {
        for (String element : object.keySet()) {
            VersionRange versions = VersionRange.fromString((String)object.get(element).getAsString());
            class_1792 item = class_7923.field_41178.method_17966(class_2960.method_60654((String)element)).orElse(null);
            if (item == null) {
                throw new IllegalStateException("Unknown item: " + element);
            }
            ITEM_DIFF.put((Object)item, (Object)versions);
        }
    }

    public static boolean keepItem(class_1792 item) {
        if (ProtocolTranslator.getTargetVersion().equals((Object)LegacyProtocolVersion.c0_30cpe)) {
            class_634 handler = class_310.method_1551().method_1562();
            if (handler == null) {
                return true;
            }
            ExtensionProtocolMetadataStorage extensionProtocol = (ExtensionProtocolMetadataStorage)((IClientConnection)handler.method_48296()).viaFabricPlus$getUserConnection().get(ExtensionProtocolMetadataStorage.class);
            if (extensionProtocol == null) {
                return false;
            }
            if (extensionProtocol.hasServerExtension(ClassicProtocolExtension.CUSTOM_BLOCKS, new int[]{1}) && CPEAdditions.EXTENDED_CLASSIC_ITEMS.contains(item)) {
                return true;
            }
        }
        return VersionedRegistries.containsItem(item, ProtocolTranslator.getTargetVersion());
    }

    public static boolean keepItem(class_1799 stack) {
        class_1844 potionContents;
        if (!VersionedRegistries.keepItem(stack.method_7909())) {
            return false;
        }
        if (VersionedRegistries.filterEnchantments((class_9331<class_9304>)class_9334.field_49633, stack)) {
            return false;
        }
        if (VersionedRegistries.filterEnchantments((class_9331<class_9304>)class_9334.field_49643, stack)) {
            return false;
        }
        class_9307 bannerPatterns = (class_9307)stack.method_58694(class_9334.field_49619);
        if (bannerPatterns != null) {
            for (class_9307.class_9308 layer : bannerPatterns.comp_2428()) {
                if (layer.comp_2429().method_40230().map(key -> VersionedRegistries.containsBannerPattern((class_5321<class_2582>)key, ProtocolTranslator.getTargetVersion())).orElse(true).booleanValue()) continue;
                return false;
            }
        }
        if ((potionContents = (class_1844)stack.method_58694(class_9334.field_49651)) != null) {
            for (class_1293 effectInstance : Objects.requireNonNull(potionContents).method_57397()) {
                if (VersionedRegistries.containsEffect((class_6880<class_1291>)effectInstance.method_5579(), ProtocolTranslator.getTargetVersion())) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean filterEnchantments(class_9331<class_9304> componentType, class_1799 stack) {
        class_9304 enchantments = (class_9304)stack.method_58694(componentType);
        if (enchantments != null) {
            for (class_6880 enchantment : enchantments.method_57534()) {
                if (enchantment.method_40230().map(key -> VersionedRegistries.containsEnchantment((class_5321<class_1887>)key, ProtocolTranslator.getTargetVersion())).orElse(true).booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsEnchantment(class_5321<class_1887> enchantment, ProtocolVersion version) {
        return !ENCHANTMENT_DIFF.containsKey(enchantment) || ((VersionRange)ENCHANTMENT_DIFF.get(enchantment)).contains(version);
    }

    public static boolean containsBannerPattern(class_5321<class_2582> bannerPattern, ProtocolVersion version) {
        return !PATTERN_DIFF.containsKey(bannerPattern) || ((VersionRange)PATTERN_DIFF.get(bannerPattern)).contains(version);
    }

    public static boolean containsEffect(class_6880<class_1291> effect, ProtocolVersion version) {
        return !EFFECT_DIFF.containsKey(effect) || ((VersionRange)EFFECT_DIFF.get(effect)).contains(version);
    }

    public static boolean containsItem(class_1792 item, ProtocolVersion version) {
        return !ITEM_DIFF.containsKey((Object)item) || ((VersionRange)ITEM_DIFF.get((Object)item)).contains(version);
    }
}

