/*
 * Decompiled with CFR 0.152.
 */
package fr.estecka.variantscit.reload;

import fr.estecka.variantscit.VariantLibrary;
import fr.estecka.variantscit.VariantsCitMod;
import fr.estecka.variantscit.reload.EAssetType;
import fr.estecka.variantscit.reload.EModuleContext;
import fr.estecka.variantscit.reload.ModuleDefinition;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.class_2960;
import net.minecraft.class_3300;

public class VariantAggregator {
    private final Map<ModuleDefinition, class_2960> moduleIds = new IdentityHashMap<ModuleDefinition, class_2960>();
    private final Map<ModuleDefinition, VariantLibrary> item_model = new IdentityHashMap<ModuleDefinition, VariantLibrary>();
    private final Map<ModuleDefinition, VariantLibrary> equippable = new IdentityHashMap<ModuleDefinition, VariantLibrary>();
    private final Set<class_2960> acceptedItemModels = new HashSet<class_2960>();
    public final Map<class_2960, ModelToCreate> modelsToCreate = new HashMap<class_2960, ModelToCreate>();
    public final Set<class_2960> itemStatesToCreate = new HashSet<class_2960>();
    public final Set<String> conflictingModelPrefixes = new HashSet<String>();

    public VariantAggregator(Map<class_2960, ModuleDefinition> modules) {
        for (Map.Entry<class_2960, ModuleDefinition> entry : modules.entrySet()) {
            ModuleDefinition module = entry.getValue();
            this.moduleIds.put(module, entry.getKey());
            for (EModuleContext context : module.contexts()) {
                this.GetLibraryMap(context).put(module, VariantAggregator.EmptyLibrary(module));
            }
        }
    }

    private static VariantLibrary EmptyLibrary(ModuleDefinition module) {
        return new VariantLibrary(module.fallbackModel().orElse(null), new HashMap<class_2960, class_2960>(), module.specialModels());
    }

    private Map<ModuleDefinition, VariantLibrary> GetLibraryMap(EModuleContext context) {
        return switch (context) {
            default -> throw new AssertionError((Object)"Invalid Context");
            case EModuleContext.EQUIPPABLE -> this.equippable;
            case EModuleContext.ITEM_MODEL -> this.item_model;
        };
    }

    public Optional<VariantLibrary> GetLibrary(EModuleContext context, ModuleDefinition module) {
        return Optional.ofNullable(this.GetLibraryMap(context).get(module));
    }

    public void GatherAll(class_3300 manager) {
        this.GatherType(EAssetType.ITEM_STATE, manager);
        this.GatherType(EAssetType.BAKED_MODEL, manager);
        this.GatherType(EAssetType.TEXTURE, manager);
        this.GatherType(EAssetType.EQUIPMENT, manager);
        this.GatherIds(EAssetType.BAKED_MODEL, this.modelsToCreate.keySet().stream());
        this.GatherIds(EAssetType.ITEM_STATE, this.itemStatesToCreate.stream());
    }

    private void GatherType(EAssetType assetType, class_3300 manager) {
        Set resources = manager.method_14488(assetType.directory, id -> id.method_12832().endsWith(assetType.suffix)).keySet();
        Stream<class_2960> ids = resources.stream().map(id -> id.method_45134(path -> path.substring(assetType.directory.length() + 1, path.length() - assetType.suffix.length())));
        this.GatherIds(assetType, ids);
    }

    private void GatherIds(EAssetType assetType, Stream<class_2960> assets) {
        assets.forEach(assetId -> this.ApplyModelToAll(assetType, (class_2960)assetId));
    }

    private void ApplyModelToAll(EAssetType assetType, class_2960 assetId) {
        for (Map.Entry<ModuleDefinition, VariantLibrary> entry : this.GetLibraryMap(assetType.context).entrySet()) {
            if (!VariantAggregator.IsTypeAcceptable(assetType, entry.getKey())) continue;
            ModuleDefinition module = entry.getKey();
            VariantLibrary library = entry.getValue();
            VariantsCitMod.LOGGER.PushLabel(this.moduleIds.get(module));
            boolean accepted = this.ApplyModelToModule(module, library, assetId);
            if (accepted && assetType.context == EModuleContext.ITEM_MODEL) {
                switch (assetType) {
                    default: {
                        break;
                    }
                    case TEXTURE: {
                        this.OnAcceptedTexture(module, assetId);
                    }
                    case BAKED_MODEL: {
                        this.OnAcceptedBakedModel(module, assetId);
                    }
                }
                this.acceptedItemModels.add(assetId);
            }
            VariantsCitMod.LOGGER.PopLabel();
        }
    }

    private static boolean IsTypeAcceptable(EAssetType type, ModuleDefinition module) {
        switch (type) {
            default: {
                return true;
            }
            case BAKED_MODEL: {
                return module.itemGen();
            }
            case TEXTURE: 
        }
        return module.itemGen() && module.modelParent().isPresent();
    }

    private boolean ApplyModelToModule(ModuleDefinition module, VariantLibrary library, class_2960 modelId) {
        boolean accepted = false;
        if (modelId.equals((Object)library.fallbackModel())) {
            accepted = true;
        }
        if (library.specialModels().containsValue(modelId)) {
            accepted = true;
        }
        if (modelId.method_12832().startsWith(module.modelPrefix())) {
            class_2960 variantId = class_2960.method_60655((String)modelId.method_12836(), (String)modelId.method_12832().substring(module.modelPrefix().length()));
            if (module.parameters().AcceptsVariant(variantId)) {
                accepted = true;
                library.variantModels().put(variantId, modelId);
            }
        }
        return accepted;
    }

    private void OnAcceptedBakedModel(ModuleDefinition module, class_2960 modelId) {
        if (!this.acceptedItemModels.contains(modelId)) {
            this.itemStatesToCreate.add(modelId);
        }
    }

    private void OnAcceptedTexture(ModuleDefinition module, class_2960 modelId) {
        int priority = module.modelPrefix().length();
        class_2960 parent = module.modelParent().get();
        ModelToCreate oldModel = this.modelsToCreate.get(modelId);
        if (oldModel != null && oldModel.priority < priority || !this.acceptedItemModels.contains(modelId)) {
            this.modelsToCreate.put(modelId, new ModelToCreate(parent, priority));
        } else if (oldModel != null && oldModel.priority == priority && !oldModel.parent.equals((Object)parent)) {
            this.conflictingModelPrefixes.add(module.modelPrefix());
        }
    }

    public record ModelToCreate(class_2960 parent, int priority) {
    }
}

