/*
 * Decompiled with CFR 0.152.
 */
package fr.estecka.variantscit.modulebakers;

import fr.estecka.variantscit.LinearSnapMap;
import fr.estecka.variantscit.VariantLibrary;
import fr.estecka.variantscit.modulebakers.GenericBakedModule;
import fr.estecka.variantscit.modulebakers.IGenericCitModule;
import fr.estecka.variantscit.modulebakers.IModuleBaker;
import java.util.Map;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class LinearLibrary {
    private final class_2960 fallback;
    private final LinearSnapMap<class_2960> modelLine = new LinearSnapMap();
    public static final IModuleBaker<ILinearCitModule> BAKER = new IModuleBaker<ILinearCitModule>(){

        public GenericBakedModule<LinearLibrary> Bake(VariantLibrary library, ILinearCitModule logic) {
            return new GenericBakedModule<LinearLibrary>(new LinearLibrary(library, logic.GetNamespace()), logic);
        }

        @Override
        public boolean AcceptVariant(class_2960 variantId, ILinearCitModule parameters) {
            if (!variantId.method_12836().equals(parameters.GetNamespace())) {
                return false;
            }
            try {
                Integer.parseUnsignedInt(variantId.method_12832());
            }
            catch (NumberFormatException e) {
                return false;
            }
            return true;
        }
    };

    public LinearLibrary(VariantLibrary variantLibrary, String allowedNamespace) {
        this.fallback = variantLibrary.fallbackModel();
        for (Map.Entry<class_2960, class_2960> variant : variantLibrary.variantModels().entrySet()) {
            if (!variant.getKey().method_12836().equals(allowedNamespace)) continue;
            try {
                int magnitude = Integer.parseInt(variant.getKey().method_12832());
                this.modelLine.AddEntry(magnitude, variant.getValue());
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    private class_2960 Fallback(@Nullable class_2960 id) {
        return id != null ? id : this.fallback;
    }

    public class_2960 GetOrLesser(int magnitude) {
        return this.Fallback(this.modelLine.GetClosestValue(magnitude, -1));
    }

    public class_2960 GetOrGreater(int magnitude) {
        return this.Fallback(this.modelLine.GetClosestValue(magnitude, 1));
    }

    public static <T extends ILinearCitModule> IModuleBaker<T> GetBaker() {
        return BAKER;
    }

    public static interface ILinearCitModule
    extends IGenericCitModule<LinearLibrary> {
        public String GetNamespace();
    }
}

