/*
 * Decompiled with CFR 0.152.
 */
package fr.estecka.variantscit.format.transforms;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import fr.estecka.variantscit.CodecUtil;
import fr.estecka.variantscit.format.IStringTransform;
import java.util.List;

public record SuccessiveTransform(IStringTransform[] subTransforms) implements IStringTransform
{
    public static final Codec<IStringTransform> CODEC = CodecUtil.OneOrMany(IStringTransform.CODEC).xmap(SuccessiveTransform::Wrap, SuccessiveTransform::Unwrap);
    public static final MapCodec<IStringTransform> MAPCODEC = IStringTransform.CODEC.listOf().fieldOf("stack").xmap(SuccessiveTransform::Wrap, SuccessiveTransform::Unwrap);

    public SuccessiveTransform(List<IStringTransform> subTransforms) {
        this((IStringTransform[])subTransforms.toArray(IStringTransform[]::new));
    }

    public static List<IStringTransform> Unwrap(IStringTransform t) {
        if (t instanceof SuccessiveTransform) {
            SuccessiveTransform succ = (SuccessiveTransform)t;
            return succ.SubTransformList();
        }
        return List.of(t);
    }

    public static IStringTransform Wrap(List<IStringTransform> sub) {
        if (sub.size() == 0) {
            return IStringTransform.NOOP;
        }
        if (sub.size() == 1) {
            return sub.get(0);
        }
        return new SuccessiveTransform(sub);
    }

    public List<IStringTransform> SubTransformList() {
        return List.of(this.subTransforms);
    }

    @Override
    public String apply(String input) {
        for (IStringTransform t : this.subTransforms) {
            if ((input = (String)t.apply(input)) != null) continue;
            return null;
        }
        return input;
    }
}

