/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.vanilla;

import java.util.Map;
import net.minecraft.class_11573;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2586;
import net.minecraft.class_2625;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3902;
import net.minecraft.class_5953;
import net.minecraft.class_5955;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;
import snownee.jade.addon.access.AccessibilityPlugin;
import snownee.jade.addon.core.ObjectNameProvider;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.IJadeProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.JadeIds;
import snownee.jade.api.StreamServerDataProvider;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.ui.Element;
import snownee.jade.api.ui.JadeUI;
import snownee.jade.impl.ui.CompoundElement;

public class WaxedProvider
implements IJadeProvider {
    @Override
    public class_2960 getUid() {
        return JadeIds.MC_WAXED;
    }

    @Override
    public int getDefaultPriority() {
        return ObjectNameProvider.BlockData.INSTANCE.getDefaultPriority() + 10;
    }

    public static class EntityData
    extends WaxedProvider
    implements StreamServerDataProvider<EntityAccessor, class_3902> {
        public static final EntityData INSTANCE = new EntityData();

        @Override
        @Nullable
        public class_3902 streamData(EntityAccessor accessor) {
            class_11573 golem = (class_11573)accessor.getEntity();
            return golem.field_61264 == -2L ? class_3902.field_17274 : null;
        }

        @Override
        public class_9139<class_9129, class_3902> streamCodec() {
            return class_3902.field_55626.method_56430();
        }
    }

    public static class EntityComponent
    extends WaxedProvider
    implements IEntityComponentProvider {
        public static final EntityComponent INSTANCE = new EntityComponent();
        private static final Map<class_5955.class_5811, class_2248> COPPER_GOLEM_STATUES = Map.of(class_5955.class_5811.field_28704, class_2246.field_61396, class_5955.class_5811.field_28705, class_2246.field_61397, class_5955.class_5811.field_28706, class_2246.field_61398, class_5955.class_5811.field_28707, class_2246.field_61399);

        @Override
        public Element getIcon(EntityAccessor accessor, IPluginConfig config, Element currentIcon) {
            class_11573 golem = (class_11573)accessor.getEntity();
            class_5955.class_5811 state = golem.method_72477();
            class_2248 statueBlock = COPPER_GOLEM_STATUES.get(state);
            boolean waxed = EntityData.INSTANCE.decodeFromData(accessor).isPresent();
            if (waxed) {
                statueBlock = class_5953.method_34720((class_2680)statueBlock.method_9564()).orElse(statueBlock.method_9564()).method_26204();
            }
            return BlockComponent.waxedIcon(JadeUI.item(new class_1799((class_1935)statueBlock)), waxed);
        }

        @Override
        public void appendTooltip(ITooltip tooltip, EntityAccessor accessor, IPluginConfig config) {
            boolean waxed;
            if (IWailaConfig.get().accessibility().getEnableAccessibilityPlugin() && config.get(JadeIds.ACCESS_ENTITY_DETAILS) && (waxed = EntityData.INSTANCE.decodeFromData(accessor).isPresent())) {
                String objectName = tooltip.getString(JadeIds.CORE_OBJECT_NAME);
                AccessibilityPlugin.replaceTitle(tooltip, objectName, "waxed");
            }
        }
    }

    public static class BlockComponent
    extends WaxedProvider
    implements IBlockComponentProvider {
        public static final BlockComponent INSTANCE = new BlockComponent();

        public static Element waxedIcon(Element icon, boolean waxed) {
            if (waxed) {
                return new CompoundElement(icon, JadeUI.item(class_1802.field_20414.method_7854(), 0.5f));
            }
            return icon;
        }

        @Override
        @Nullable
        public Element getIcon(BlockAccessor accessor, IPluginConfig config, Element currentIcon) {
            class_2586 class_25862;
            class_1799 pickedResult = accessor.getPickedResult();
            if (!pickedResult.method_7960() && (class_25862 = accessor.getBlockEntity()) instanceof class_2625) {
                class_2625 sign = (class_2625)class_25862;
                return BlockComponent.waxedIcon(JadeUI.item(pickedResult), sign.method_49855());
            }
            return currentIcon;
        }

        @Override
        public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
            class_2625 sign;
            class_2586 class_25862;
            if (IWailaConfig.get().accessibility().getEnableAccessibilityPlugin() && config.get(JadeIds.ACCESS_BLOCK_DETAILS) && (class_25862 = accessor.getBlockEntity()) instanceof class_2625 && (sign = (class_2625)class_25862).method_49855()) {
                String objectName = tooltip.getString(JadeIds.CORE_OBJECT_NAME);
                AccessibilityPlugin.replaceTitle(tooltip, objectName, "waxed");
            }
        }
    }
}

