/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.access;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Either;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3542;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9331;
import net.minecraft.class_9473;
import net.minecraft.class_9791;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import snownee.jade.mixin.EntityAccess;
import snownee.jade.util.CommonProxy;

public final class EntityVariantHelper {
    private static final Object2BooleanMap<class_9331<?>> isVariantType = new Object2BooleanOpenHashMap();
    private static final Set<class_9331<?>> isColorType = Sets.newHashSet();
    private static final Map<class_1299<?>, @Nullable class_9331<?>> variantTypeByEntity = Maps.newHashMap();

    public static synchronized void addVariantMapping(class_1299<?> entityType, @Nullable class_9331<?> variantType) {
        variantTypeByEntity.put(entityType, variantType);
        if (variantType != null && !isVariantType.containsKey(variantType)) {
            EntityVariantHelper.addVariantType(variantType, true);
        }
    }

    public static synchronized void addVariantType(class_9331<?> type, boolean isVariant) {
        boolean isColor;
        class_2960 key = class_7923.field_49658.method_10221(type);
        if (key == null) {
            isVariant = false;
        }
        isVariantType.put(type, isVariant);
        boolean bl = isColor = key != null && key.method_12832().endsWith("/color");
        if (isColor) {
            isColorType.add(type);
        }
    }

    @Nullable
    public static synchronized class_9331<?> getVariantType(class_1297 entity) {
        class_1299 entityType = entity.method_5864();
        if (variantTypeByEntity.containsKey(entityType)) {
            return variantTypeByEntity.get(entityType);
        }
        for (class_9331<?> type : EntityVariantHelper.componentTypes(entity)) {
            if (!EntityVariantHelper.isVariantType(type)) continue;
            variantTypeByEntity.put(entityType, type);
            return type;
        }
        return null;
    }

    @Nullable
    public static synchronized Object getVariant(class_1297 entity, boolean isColor) {
        class_9331<?> type = EntityVariantHelper.getVariantType(entity);
        if (type == null || isColorType.contains(type) != isColor) {
            return null;
        }
        return entity.method_58694(type);
    }

    @Nullable
    public static synchronized Either<String, class_2561> getVariantName(class_1297 entity, boolean isColor) {
        class_2960 id;
        Object variant = EntityVariantHelper.getVariant(entity, isColor);
        if (variant == null) {
            return null;
        }
        if (variant instanceof class_6880) {
            class_6880 holder = (class_6880)variant;
            id = holder.method_40230().map(class_5321::method_29177).orElse(null);
            variant = id != null ? id : holder.comp_349();
        } else if (variant instanceof class_9791) {
            class_9791 holder = (class_9791)variant;
            variant = holder.method_67385().map(class_5321::method_29177).orElse(null);
        }
        String name = null;
        Either<String, class_2561> result = CommonProxy.getTranslatableName(variant);
        if (result != null) {
            return result;
        }
        if (variant instanceof class_2960) {
            id = (class_2960)variant;
            name = id.method_43903();
        } else if (variant instanceof String) {
            name = variant.toString();
        } else if (variant instanceof class_3542) {
            class_3542 stringRepresentable = (class_3542)variant;
            name = stringRepresentable.method_15434();
        } else if (variant instanceof Enum) {
            Enum enumValue = (Enum)variant;
            name = enumValue.name();
        }
        return name == null ? null : Either.left((Object)name.toLowerCase(Locale.ENGLISH));
    }

    private static boolean isVariantType(class_9331<?> type) {
        if (isVariantType.containsKey(type)) {
            return isVariantType.getBoolean(type);
        }
        class_2960 key = class_7923.field_49658.method_10221(type);
        if (key == null) {
            EntityVariantHelper.addVariantType(type, false);
            return false;
        }
        String name = key.method_12832();
        boolean result = name.endsWith("/variant") || key.method_12832().endsWith("/color");
        EntityVariantHelper.addVariantType(type, result);
        return result;
    }

    private static List<class_9331<?>> componentTypes(class_1297 entity) {
        final ArrayList types = Lists.newArrayList();
        ((EntityAccess)entity).callApplyImplicitComponents(new class_9473(){

            @Nullable
            public <T> T method_58694(@NotNull class_9331<? extends T> dataComponentType) {
                types.add(dataComponentType);
                return null;
            }
        });
        return types;
    }
}

