/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.extension.factory.parser.mask;

import com.sk89q.worldedit.EmptyClipboardException;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.extension.input.InputParseException;
import com.sk89q.worldedit.extension.input.ParserContext;
import com.sk89q.worldedit.function.mask.Mask;
import com.sk89q.worldedit.function.mask.MatchMask;
import com.sk89q.worldedit.internal.registry.SimpleInputParser;
import com.sk89q.worldedit.util.formatting.text.TranslatableComponent;
import java.util.List;

public class ClipboardMaskParser
extends SimpleInputParser<Mask> {
    private static final List<String> aliases = List.of("#clipboard", "#copy");

    public ClipboardMaskParser(WorldEdit worldEdit) {
        super(worldEdit);
    }

    @Override
    public List<String> getMatchedAliases() {
        return aliases;
    }

    @Override
    public Mask parseFromSimpleInput(String input, ParserContext context) throws InputParseException {
        try {
            return new MatchMask(context.requireExtent(), context.requireSession().getClipboard().getClipboard());
        }
        catch (EmptyClipboardException e) {
            throw new InputParseException(TranslatableComponent.of("worldedit.error.empty-clipboard"));
        }
    }
}

