/*
 * Decompiled with CFR 0.152.
 */
package mc.euphoria_patches.euphoria_patcher.util;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import mc.euphoria_patches.euphoria_patcher.EuphoriaPatcher;
import mc.euphoria_patches.euphoria_patcher.features.UpdateShaderConfig;
import mc.euphoria_patches.euphoria_patcher.features.UpdateShaderLoaderConfig;
import mc.euphoria_patches.euphoria_patcher.util.EuphoriaLogger;
import mc.euphoria_patches.euphoria_patcher.util.ModLoaderSpecifics;
import mc.euphoria_patches.euphoria_patcher.util.PotatoFileMonitor;
import mc.euphoria_patches.euphoria_patcher.util.ShaderLoader;
import mc.euphoria_patches.euphoria_patcher.util.UpdateChecker;

public class IrisDefineHelper {
    private static int injectCount = 0;
    private static boolean injectedOnce = false;

    private static void debugLog(String message) {
        EuphoriaLogger.debugLog("[IrisDefineHelper] " + message);
    }

    public static void addEuphoriaDefines(List<?> standardDefines, boolean isLegacy, BiConsumer<List<?>, String> defineKey, BiConsumer<List<?>, String[]> defineKeyValue) {
        try {
            Path currentShaderpack;
            ++injectCount;
            IrisDefineHelper.debugLog("Adding Euphoria Patches defines to Iris" + (isLegacy ? " (Legacy)" : ""));
            if (EuphoriaPatcher.isSpacEagle()) {
                defineKey.accept(standardDefines, "SPACEAGLE17");
                IrisDefineHelper.debugLog("Adding SPACEEAGLE17 define");
            }
            String currentVersion = IrisDefineHelper.formatVersion("_1.7.7");
            defineKeyValue.accept(standardDefines, new String[]{"CURRENT_EUPHORIA_PATCHES_VERSION", currentVersion});
            IrisDefineHelper.debugLog("Adding CURRENT_EUPHORIA_PATCHES_VERSION define");
            defineKey.accept(standardDefines, "EUPHORIA_PATCHES_MOD_INSTALLED");
            IrisDefineHelper.debugLog("Adding EUPHORIA_PATCHES_MOD_INSTALLED define");
            String currentDimension = "CURRENT_EUPHORIA_PATCHES_DIMENSION_" + ModLoaderSpecifics.getCurrentDimension().toUpperCase();
            defineKey.accept(standardDefines, currentDimension);
            IrisDefineHelper.debugLog("Adding " + currentDimension + " define");
            if (ShaderLoader.getShaderLoader().equals("iris")) {
                defineKey.accept(standardDefines, "EUPHORIA_PATCHES_IRIS");
                IrisDefineHelper.debugLog("Adding EUPHORIA_PATCHES_IRIS define");
            }
            if ((currentShaderpack = UpdateShaderLoaderConfig.getCurrentShaderpackPath()) != null) {
                if (PotatoFileMonitor.shouldAddPotatoRemovedDefine(currentShaderpack)) {
                    defineKey.accept(standardDefines, "EUPHORIA_PATCHES_POTATO_REMOVED");
                    IrisDefineHelper.debugLog("Adding EUPHORIA_PATCHES_POTATO_REMOVED define - potato.png not found");
                } else {
                    IrisDefineHelper.debugLog("Not adding EUPHORIA_PATCHES_POTATO_REMOVED define - potato.png found");
                }
            } else {
                IrisDefineHelper.debugLog("Cannot check for potato.png - currentShaderpack is null");
            }
            if (UpdateChecker.isUpdateAvailable() && UpdateChecker.isMajorUpdate() && EuphoriaPatcher.doDisplayShaderInGameMessage && !injectedOnce) {
                defineKey.accept(standardDefines, "NEW_EUPHORIA_PATCHES_UPDATE");
                IrisDefineHelper.debugLog("Adding NEW_EUPHORIA_PATCHES_UPDATE define");
                if (UpdateChecker.getNewModVersion() != null) {
                    String nextVersionFormatted = IrisDefineHelper.formatVersion(UpdateChecker.getNewModVersion());
                    defineKeyValue.accept(standardDefines, new String[]{"NEXT_EUPHORIA_PATCHES_VERSION", nextVersionFormatted});
                    IrisDefineHelper.debugLog("Adding NEXT_EUPHORIA_PATCHES_VERSION: " + nextVersionFormatted + " define");
                }
            }
            UpdateShaderConfig.markEuphoriaPatchesSettingsFiles();
            if (injectCount == 1) {
                EuphoriaPatcher.log(0, "Added Euphoria Patches defines to Iris" + (isLegacy ? " (Legacy)" : ""));
            }
            injectedOnce = true;
        }
        catch (Exception e) {
            IrisDefineHelper.debugLog("Exception while adding defines: " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean checkPotatoExists(Path shaderpackPath) {
        String potatoRelativePath = "shaders/lib/textures/potato.png";
        IrisDefineHelper.debugLog("Checking for potato.png in shaderpack: " + shaderpackPath);
        try {
            if (Files.isDirectory(shaderpackPath, new LinkOption[0])) {
                Path potatoPath = shaderpackPath.resolve(potatoRelativePath);
                boolean exists = Files.exists(potatoPath, new LinkOption[0]);
                IrisDefineHelper.debugLog("Directory shaderpack: potato.png " + (exists ? "exists" : "does not exist") + " at " + potatoPath);
                return exists;
            }
            if (Files.isRegularFile(shaderpackPath, new LinkOption[0]) && shaderpackPath.toString().toLowerCase(Locale.ROOT).endsWith(".zip")) {
                try (ZipFile zipFile = new ZipFile(shaderpackPath.toFile());){
                    ZipEntry entry = zipFile.getEntry(potatoRelativePath);
                    boolean exists = entry != null;
                    IrisDefineHelper.debugLog("ZIP shaderpack: potato.png " + (exists ? "exists" : "does not exist") + " in " + shaderpackPath);
                    boolean bl = exists;
                    return bl;
                }
                catch (IOException e) {
                    IrisDefineHelper.debugLog("Error reading ZIP file: " + e.getMessage());
                    return false;
                }
            }
            IrisDefineHelper.debugLog("Shaderpack is neither a directory nor a ZIP file: " + shaderpackPath);
            return false;
        }
        catch (Exception e) {
            IrisDefineHelper.debugLog("Exception checking for potato.png: " + e.getMessage());
            return false;
        }
    }

    public static String formatVersion(String version) {
        String[] versionParts = version.replace("_", "").split("\\.");
        StringBuilder versionBuilder = new StringBuilder();
        for (int i = 0; i < versionParts.length; ++i) {
            versionBuilder.append("_").append(versionParts[i]);
            if (i >= versionParts.length - 1) continue;
            versionBuilder.append(", _dot, ");
        }
        return versionBuilder.toString();
    }
}

