/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.modelfix.moonlight_configs.fabric;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.mehvahdjukaar.modelfix.moonlight_configs.ConfigBuilder;
import net.mehvahdjukaar.modelfix.moonlight_configs.ConfigSpec;
import net.mehvahdjukaar.modelfix.moonlight_configs.ConfigType;
import net.mehvahdjukaar.modelfix.moonlight_configs.fabric.ConfigSubCategory;
import net.mehvahdjukaar.modelfix.moonlight_configs.fabric.FabricConfigSpec;
import net.mehvahdjukaar.modelfix.moonlight_configs.fabric.values.BoolConfigValue;
import net.mehvahdjukaar.modelfix.moonlight_configs.fabric.values.ConfigValue;
import net.mehvahdjukaar.modelfix.moonlight_configs.fabric.values.DoubleConfigValue;
import net.mehvahdjukaar.modelfix.moonlight_configs.fabric.values.EnumConfigValue;
import net.mehvahdjukaar.modelfix.moonlight_configs.fabric.values.FloatConfigValue;
import net.mehvahdjukaar.modelfix.moonlight_configs.fabric.values.IntConfigValue;
import net.mehvahdjukaar.modelfix.moonlight_configs.fabric.values.ListStringConfigValue;
import net.mehvahdjukaar.modelfix.moonlight_configs.fabric.values.StringConfigValue;
import net.minecraft.class_2960;
import org.apache.http.annotation.Experimental;
import org.jetbrains.annotations.NotNull;

public class ConfigBuilderImpl
extends ConfigBuilder {
    private final ConfigSubCategory mainCategory = new ConfigSubCategory(this.getName().method_12836());
    private final Deque<ConfigSubCategory> categoryStack = new ArrayDeque<ConfigSubCategory>();

    public static ConfigBuilder create(class_2960 name, ConfigType type) {
        return new ConfigBuilderImpl(name, type);
    }

    public ConfigBuilderImpl(class_2960 name, ConfigType type) {
        super(name, type);
        this.categoryStack.push(this.mainCategory);
    }

    @Override
    @NotNull
    public FabricConfigSpec build() {
        assert (this.categoryStack.size() == 1);
        return new FabricConfigSpec(this.getName(), this.mainCategory, this.type, this.changeCallback);
    }

    @Override
    public String currentCategory() {
        return this.categoryStack.peek().getName();
    }

    @Override
    public ConfigBuilderImpl push(String translation) {
        ConfigSubCategory cat = new ConfigSubCategory(translation);
        this.categoryStack.peek().addEntry(cat);
        this.categoryStack.push(cat);
        return this;
    }

    @Override
    public ConfigBuilderImpl pop() {
        assert (this.categoryStack.size() != 1);
        this.categoryStack.pop();
        return this;
    }

    private void doAddConfig(String name, ConfigValue<?> config) {
        config.setTranslationKey(this.translationKey(name));
        this.maybeAddTranslationString(name);
        String tooltipKey = this.tooltipKey(name);
        if (this.comments.containsKey(tooltipKey)) {
            config.setDescriptionKey(tooltipKey);
        }
        this.categoryStack.peek().addEntry(config);
        if (this.categoryStack.size() <= 1) {
            throw new AssertionError();
        }
    }

    @Override
    public Supplier<Boolean> define(String name, boolean defaultValue) {
        BoolConfigValue config = new BoolConfigValue(name, defaultValue);
        this.doAddConfig(name, config);
        return config;
    }

    @Override
    public Supplier<Double> define(String name, double defaultValue, double min, double max) {
        DoubleConfigValue config = new DoubleConfigValue(name, defaultValue, min, max);
        this.doAddConfig(name, config);
        return config;
    }

    @Override
    @Experimental
    public Supplier<Float> define(String name, float defaultValue, float min, float max) {
        FloatConfigValue config = new FloatConfigValue(name, Float.valueOf(defaultValue), Float.valueOf(min), Float.valueOf(max));
        this.doAddConfig(name, config);
        return config;
    }

    @Override
    public Supplier<Integer> define(String name, int defaultValue, int min, int max) {
        IntConfigValue config = new IntConfigValue(name, defaultValue, min, max);
        this.doAddConfig(name, config);
        return config;
    }

    @Override
    public Supplier<String> define(String name, String defaultValue, Predicate<Object> validator) {
        StringConfigValue config = new StringConfigValue(name, defaultValue, validator);
        this.doAddConfig(name, config);
        return config;
    }

    @Override
    public <T extends String> Supplier<List<String>> define(String name, List<? extends T> defaultValue, Predicate<Object> predicate) {
        ListStringConfigValue config = new ListStringConfigValue(name, defaultValue, predicate);
        this.doAddConfig(name, config);
        return config;
    }

    @Override
    public <V extends Enum<V>> Supplier<V> define(String name, V defaultValue) {
        EnumConfigValue<V> config = new EnumConfigValue<V>(name, defaultValue);
        this.doAddConfig(name, config);
        return config;
    }

    @Override
    protected void maybeAddTranslationString(String name) {
        this.comments.put(this.translationKey(name), ConfigSpec.getReadableName(name));
        super.maybeAddTranslationString(name);
    }

    @Override
    public ConfigBuilder gameRestart() {
        return this;
    }

    @Override
    public ConfigBuilder worldReload() {
        return this;
    }

    @Override
    public ConfigBuilder comment(String comment) {
        return super.comment(comment);
    }
}

