/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models.parts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_630;
import traben.entity_model_features.EMF;
import traben.entity_model_features.config.EMFConfig;
import traben.entity_model_features.models.parts.EMFModelPartCustom;
import traben.entity_model_features.models.parts.EMFModelPartWithState;
import traben.entity_model_features.utils.EMFUtils;

public class EMFModelPartVanilla
extends EMFModelPartWithState {
    final String name;
    final boolean isOptiFinePartSpecified;
    final Set<Integer> hideInTheseStates = new HashSet<Integer>();

    public EMFModelPartVanilla(String name, class_630 vanillaPart, Collection<String> optifinePartNames, Map<String, EMFModelPartVanilla> allVanillaParts) {
        super(new ArrayList<class_630.class_628>(), new HashMap<String, class_630>());
        this.name = name;
        if (((EMFConfig)EMF.config().getConfig()).logModelCreationData) {
            EMFUtils.log(" > EMF vanilla part made: " + name);
        }
        this.isOptiFinePartSpecified = optifinePartNames.contains(name);
        this.setFromState(this.getStateOf(vanillaPart));
        for (Map.Entry child : vanillaPart.field_3661.entrySet()) {
            EMFModelPartVanilla vanilla = new EMFModelPartVanilla((String)child.getKey(), (class_630)child.getValue(), optifinePartNames, allVanillaParts);
            this.field_3661.put((String)child.getKey(), vanilla);
            allVanillaParts.put((String)child.getKey(), vanilla);
        }
        this.vanillaChildren = this.field_3661;
        this.allKnownStateVariants.put(0, (Object)this.getCurrentState());
    }

    public class_630[] getAllEMFCustomChildren() {
        return (class_630[])this.field_3661.values().stream().filter(part -> part instanceof EMFModelPartCustom).toArray(class_630[]::new);
    }

    @Override
    protected float[] debugBoxColor() {
        return new float[]{0.0f, 1.0f, 0.0f};
    }

    @Override
    public void method_22699(class_4587 matrices, class_4588 vertices, int light, int overlay, int k) {
        if (!this.hideInTheseStates.contains(this.currentModelVariant)) {
            super.method_22699(matrices, vertices, light, overlay, k);
        }
    }

    public void setHideInTheseStates(int variant) {
        this.hideInTheseStates.add(variant);
        this.field_3661.values().forEach(part -> {
            if (part instanceof EMFModelPartVanilla) {
                EMFModelPartVanilla vanilla = (EMFModelPartVanilla)((Object)part);
                if (!vanilla.isOptiFinePartSpecified) {
                    vanilla.setHideInTheseStates(variant);
                }
            }
        });
    }

    public void receiveRootAnimationRunnable(int variant, Runnable run) {
        ((EMFModelPartWithState.EMFModelState)this.allKnownStateVariants.get(variant)).animation().setAnimation(run);
    }

    @Override
    public String toString() {
        return "[vanilla part " + this.name + "], cubes =" + this.field_3663.size() + ", children = " + this.field_3661.size();
    }

    @Override
    public String toStringShort() {
        return "[vanilla part " + this.name + "]";
    }
}

