/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.worldeditcui.event;

import com.google.common.base.Joiner;
import java.util.List;
import org.enginehub.worldeditcui.WorldEditCUI;
import org.enginehub.worldeditcui.event.CUIEventArgs;
import org.enginehub.worldeditcui.event.CUIEventType;

public abstract class CUIEvent {
    protected final WorldEditCUI controller;
    protected final List<String> params;
    protected final boolean multi;

    public CUIEvent(CUIEventArgs args) {
        this.controller = args.getController();
        this.params = args.getParams();
        this.multi = args.isMulti();
    }

    public abstract String raise();

    public abstract CUIEventType getEventType();

    public String getEventName() {
        return this.getEventType().getName();
    }

    public boolean isValid() {
        int min;
        int max = this.getEventType().getMaxParameters();
        return !(max == (min = this.getEventType().getMinParameters()) ? this.params.size() != max : this.params.size() > max || this.params.size() < min);
    }

    public void prepare() {
        if (this.controller == null || this.params == null) {
            throw new IllegalStateException("Controller and parameters must both be set.");
        }
        if (!this.isValid()) {
            String message = String.format("Invalid number of parameters. %s event requires %s parameters but received %s [%s]", this.getEventName(), this.getRequiredParameterString(), this.params.size(), Joiner.on((String)", ").join(this.params));
            throw new IllegalArgumentException(message);
        }
    }

    private String getRequiredParameterString() {
        if (this.getEventType().getMaxParameters() == this.getEventType().getMinParameters()) {
            return String.valueOf(this.getEventType().getMaxParameters());
        }
        return String.format("between %d and %d", this.getEventType().getMinParameters(), this.getEventType().getMaxParameters());
    }

    public int getInt(int index) {
        return (int)Float.parseFloat(this.params.get(index));
    }

    public double getDouble(int index) {
        return Double.parseDouble(this.params.get(index));
    }

    public String getString(int index) {
        return this.params.get(index);
    }
}

