/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.processor.overlay;

import me.pepperbell.continuity.api.client.QuadProcessor;
import me.pepperbell.continuity.client.processor.ProcessingPredicate;
import me.pepperbell.continuity.client.processor.overlay.OverlayProcessingPredicate;
import me.pepperbell.continuity.client.processor.simple.SimpleQuadProcessor;
import me.pepperbell.continuity.client.processor.simple.SpriteProvider;
import me.pepperbell.continuity.client.properties.BaseCtmProperties;
import me.pepperbell.continuity.client.properties.overlay.OverlayPropertiesSection;
import me.pepperbell.continuity.client.util.QuadUtil;
import me.pepperbell.continuity.client.util.RenderUtil;
import me.pepperbell.continuity.client.util.TextureUtil;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadView;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1058;
import net.minecraft.class_11515;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class SimpleOverlayQuadProcessor
extends SimpleQuadProcessor {
    protected int tintIndex;
    @Nullable
    protected class_2680 tintBlock;
    protected class_11515 layer;
    protected TriState ao;

    public SimpleOverlayQuadProcessor(SpriteProvider spriteProvider, ProcessingPredicate processingPredicate, int tintIndex, @Nullable class_2680 tintBlock, class_11515 layer) {
        super(spriteProvider, processingPredicate);
        this.tintIndex = tintIndex;
        this.tintBlock = tintBlock;
        this.layer = layer;
        this.ao = RenderUtil.aoFromTintBlock(tintBlock);
    }

    @Override
    public QuadProcessor.ProcessingResult processQuad(MutableQuadView quad, class_1058 sprite, class_1920 blockView, class_2338 pos, class_2680 appearanceState, class_2680 state, class_5819 random, int pass, QuadProcessor.ProcessingContext context) {
        class_1058 newSprite;
        if (this.processingPredicate.shouldProcessQuad((QuadView)quad, sprite, blockView, pos, appearanceState, state, context) && (newSprite = this.spriteProvider.getSprite((QuadView)quad, sprite, blockView, pos, appearanceState, state, random, context)) != null && !TextureUtil.isMissingSprite(newSprite)) {
            QuadUtil.emitOverlayQuad(context.getExtraQuadEmitter(), quad.lightFace(), newSprite, RenderUtil.getTintColor(this.tintBlock, blockView, pos, this.tintIndex), this.layer, this.ao);
        }
        return QuadProcessor.ProcessingResult.NEXT_PROCESSOR;
    }

    public static class Factory<T extends BaseCtmProperties>
    extends SimpleQuadProcessor.Factory<T> {
        public Factory(SpriteProvider.Factory<? super T> spriteProviderFactory) {
            super(spriteProviderFactory);
        }

        @Override
        public QuadProcessor createProcessor(T properties, class_1058[] sprites) {
            OverlayPropertiesSection overlaySection = ((OverlayPropertiesSection.Provider)properties).getOverlayPropertiesSection();
            return new SimpleOverlayQuadProcessor(this.spriteProviderFactory.createSpriteProvider(sprites, properties), OverlayProcessingPredicate.fromProperties(properties), overlaySection.getTintIndex(), overlaySection.getTintBlock(), overlaySection.getLayer());
        }

        @Override
        public boolean supportsNullSprites(T properties) {
            return false;
        }
    }
}

