/*
 * Decompiled with CFR 0.152.
 */
package net.immortaldevs.bindcmd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.immortaldevs.bindcmd.CmdType;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J%\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00072\u0006\u0010\u0006\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\f\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u000f\u0010\rJ\u0017\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0010\u0010\rJ\u0013\u0010\u0012\u001a\u00020\u0011*\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013R$\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\b8\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R$\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00028\u0006@BX\u0086\u000e\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0019\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lnet/immortaldevs/bindcmd/Command;", "", "", "command", "<init>", "(Ljava/lang/String;)V", "cmd", "Lkotlin/Pair;", "Lnet/immortaldevs/bindcmd/CmdType;", "getLastMessage", "(Ljava/lang/String;)Lkotlin/Pair;", "message", "processMessage", "(Ljava/lang/String;)Ljava/lang/String;", "expression", "replaceVariables", "evaluateExpression", "", "isDouble", "(Ljava/lang/String;)Z", "value", "type", "Lnet/immortaldevs/bindcmd/CmdType;", "getType", "()Lnet/immortaldevs/bindcmd/CmdType;", "Ljava/lang/String;", "getCommand", "()Ljava/lang/String;", "fabric-bind-cmd"})
@SourceDebugExtension(value={"SMAP\nCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Command.kt\nnet/immortaldevs/bindcmd/Command\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,187:1\n216#2,2:188\n1563#3:190\n1634#3,3:191\n*S KotlinDebug\n*F\n+ 1 Command.kt\nnet/immortaldevs/bindcmd/Command\n*L\n78#1:188,2\n92#1:190\n92#1:191,3\n*E\n"})
public final class Command {
    @NotNull
    private CmdType type;
    @NotNull
    private String command;

    public Command(@NotNull String command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        if (((CharSequence)command).length() == 0) {
            this.type = CmdType.NONE;
            this.command = "";
        } else if (command.charAt(0) == '/') {
            this.type = CmdType.COMMAND;
            String string = command.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            this.command = this.processMessage(string);
        } else if (command.charAt(0) == '@') {
            Pair pair = this.getLastMessage(command);
            if (pair == null) {
                pair = new Pair((Object)CmdType.NONE, (Object)"");
            }
            Pair pair2 = pair;
            CmdType type = (CmdType)((Object)pair2.component1());
            String cmd = (String)pair2.component2();
            this.type = type;
            this.command = this.processMessage(cmd);
        } else {
            this.type = CmdType.MESSAGE;
            this.command = this.processMessage(command);
        }
    }

    @NotNull
    public final CmdType getType() {
        return this.type;
    }

    @NotNull
    public final String getCommand() {
        return this.command;
    }

    private final Pair<CmdType, String> getLastMessage(String cmd) {
        int offset;
        class_329 class_3292 = class_310.method_1551().field_1705;
        if (class_3292 == null || (class_3292 = class_3292.method_1743()) == null || (class_3292 = class_3292.method_1809()) == null) {
            return null;
        }
        class_329 history = class_3292;
        if (cmd.length() > 1) {
            String string = cmd.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            Integer n = StringsKt.toIntOrNull((String)string);
            v3 = n != null ? n : 1;
        } else {
            v3 = offset = 1;
        }
        if (history.size() - offset < 0) {
            return null;
        }
        String message = (String)history.get(history.size() - offset);
        if (message.charAt(0) == '/') {
            Intrinsics.checkNotNull((Object)message);
            String string = message.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            return new Pair((Object)CmdType.COMMAND, (Object)string);
        }
        return new Pair((Object)CmdType.MESSAGE, (Object)message);
    }

    private final String processMessage(String message) {
        if (!StringsKt.contains$default((CharSequence)message, (CharSequence)"$", (boolean)false, (int)2, null)) {
            return message;
        }
        Regex regex = new Regex("\\$\\{(.+?)}|\\$(\\w+)");
        CharSequence charSequence = message;
        Function1 function1 = arg_0 -> Command.processMessage$lambda$0(this, arg_0);
        return regex.replace(charSequence, function1);
    }

    private final String replaceVariables(String expression) {
        Map variables;
        class_746 class_7462 = class_310.method_1551().field_1724;
        if (class_7462 == null) {
            return expression;
        }
        class_746 player = class_7462;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"username", (Object)player.method_5477().getString()), TuplesKt.to((Object)"maxHealth", (Object)String.valueOf(player.method_6063())), TuplesKt.to((Object)"health", (Object)String.valueOf(player.method_6032())), TuplesKt.to((Object)"hunger", (Object)String.valueOf(player.method_7344().method_7586())), TuplesKt.to((Object)"x", (Object)String.valueOf(player.method_31477())), TuplesKt.to((Object)"y", (Object)String.valueOf(player.method_31478())), TuplesKt.to((Object)"z", (Object)String.valueOf(player.method_31479()))};
        Map $this$forEach$iv = variables = MapsKt.mapOf((Pair[])pairArray);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl = false;
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!StringsKt.contains$default((CharSequence)expression, (CharSequence)key, (boolean)false, (int)2, null)) continue;
            Intrinsics.checkNotNull((Object)value);
            return StringsKt.replace$default((String)expression, (String)key, (String)value, (boolean)false, (int)4, null);
        }
        return expression;
    }

    /*
     * WARNING - void declaration
     */
    private final String evaluateExpression(String expression) {
        Iterator $this$mapTo$iv$iv;
        void $this$map$iv;
        List output = new ArrayList();
        List operators = new ArrayList();
        Object[] objectArray = new String[]{"sqrt", "cbrt", "min", "max", "floor", "ceil", "round", "abs", "sin", "cos", "tan", "asin", "acos", "atan", "atan2", "sinh", "cosh", "tanh", "exp", "ln", "log", "log2", "log10"};
        List methods = CollectionsKt.listOf((Object[])objectArray);
        Object object = new Pair[]{TuplesKt.to((Object)"+", (Object)2), TuplesKt.to((Object)"-", (Object)2), TuplesKt.to((Object)"*", (Object)3), TuplesKt.to((Object)"/", (Object)3), TuplesKt.to((Object)"%", (Object)3), TuplesKt.to((Object)"^", (Object)4)};
        Map map = MapsKt.mapOf((Pair[])object);
        object = methods;
        Map map2 = map;
        boolean $i$f$map = false;
        void var8_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv$iv = iterator.next();
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)it, (Object)5));
        }
        Map precedence = MapsKt.plus((Map)map2, (Iterable)((List)destination$iv$iv));
        String pattern = "([\\-0-9.]+)|\\s*([()+\\-*/%^]|" + CollectionsKt.joinToString$default((Iterable)methods, (CharSequence)"|", null, null, (int)0, null, null, (int)62, null) + ")\\s*";
        List tokens = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)Regex.findAll$default((Regex)new Regex(pattern), (CharSequence)StringsKt.replace$default((String)expression, (String)" ", (String)"", (boolean)false, (int)4, null), (int)0, (int)2, null), Command::evaluateExpression$lambda$1));
        if (tokens.size() < 2) {
            return expression;
        }
        for (Object token : tokens) {
            if (Intrinsics.areEqual((Object)token, (Object)"(")) {
                operators.add(token);
                continue;
            }
            if (Intrinsics.areEqual((Object)token, (Object)")")) {
                while (!Intrinsics.areEqual((Object)CollectionsKt.last((List)operators), (Object)"(")) {
                    Object e = operators.removeLast();
                    Intrinsics.checkNotNullExpressionValue(e, (String)"removeLast(...)");
                    output.add(e);
                }
                operators.removeLast();
                continue;
            }
            if (this.isDouble((String)token)) {
                output.add(token);
                continue;
            }
            if (!precedence.keySet().contains(token)) continue;
            while (!((Collection)operators).isEmpty() && !Intrinsics.areEqual((Object)CollectionsKt.last((List)operators), (Object)"(")) {
                Object v = precedence.get(token);
                Intrinsics.checkNotNull(v);
                int n = ((Number)v).intValue();
                Object v2 = precedence.get(CollectionsKt.last((List)operators));
                Intrinsics.checkNotNull(v2);
                if (n >= ((Number)v2).intValue() && (!Intrinsics.areEqual(precedence.get(token), precedence.get(CollectionsKt.last((List)operators))) || CollectionsKt.listOf((Object[])($i$f$mapTo = new String[]{"*", "/", "%"})).contains(token))) break;
                Object e = operators.removeLast();
                Intrinsics.checkNotNullExpressionValue(e, (String)"removeLast(...)");
                output.add(e);
            }
            operators.add(token);
        }
        while (!((Collection)operators).isEmpty()) {
            Object e = operators.removeLast();
            Intrinsics.checkNotNullExpressionValue(e, (String)"removeLast(...)");
            output.add(e);
        }
        List stack = new ArrayList();
        for (String token : output) {
            block108: {
                if (this.isDouble(token)) {
                    stack.add(Double.parseDouble(token));
                    continue;
                }
                if (!methods.contains(token)) break block108;
                Object e = stack.removeLast();
                Intrinsics.checkNotNullExpressionValue(e, (String)"removeLast(...)");
                double operand = ((Number)e).doubleValue();
                double result = switch (token) {
                    case "min" -> {
                        Object v8 = stack.removeLast();
                        Intrinsics.checkNotNullExpressionValue(v8, (String)"removeLast(...)");
                        double var16_26 = ((Number)v8).doubleValue();
                        yield Math.min(operand, var16_26);
                    }
                    case "max" -> {
                        Object v10 = stack.removeLast();
                        Intrinsics.checkNotNullExpressionValue(v10, (String)"removeLast(...)");
                        double var16_26 = ((Number)v10).doubleValue();
                        yield Math.max(operand, var16_26);
                    }
                    case "floor" -> Math.floor(operand);
                    case "ceil" -> Math.ceil(operand);
                    case "round" -> Math.rint(operand);
                    case "sqrt" -> Math.sqrt(operand);
                    case "cbrt" -> Math.cbrt(operand);
                    case "abs" -> Math.abs(operand);
                    case "sin" -> Math.sin(operand);
                    case "cos" -> Math.cos(operand);
                    case "tan" -> Math.tan(operand);
                    case "asin" -> Math.asin(operand);
                    case "acos" -> Math.acos(operand);
                    case "atan" -> Math.atan(operand);
                    case "atan2" -> {
                        Object v11 = stack.removeLast();
                        Intrinsics.checkNotNullExpressionValue(v11, (String)"removeLast(...)");
                        double var16_26 = ((Number)v11).doubleValue();
                        yield Math.atan2(operand, var16_26);
                    }
                    case "sinh" -> Math.sinh(operand);
                    case "cosh" -> Math.cosh(operand);
                    case "tanh" -> Math.tanh(operand);
                    case "exp" -> Math.exp(operand);
                    case "ln" -> Math.log(operand);
                    case "log" -> {
                        Object v12 = stack.removeLast();
                        Intrinsics.checkNotNullExpressionValue(v12, (String)"removeLast(...)");
                        yield MathKt.log((double)((Number)v12).doubleValue(), (double)operand);
                    }
                    case "log2" -> MathKt.log2((double)operand);
                    case "log10" -> Math.log10(operand);
                    default -> throw new IllegalArgumentException("Unknown operator: " + token);
                };
                stack.add(result);
                continue;
            }
            if (!precedence.keySet().contains(token)) continue;
            Object e = stack.removeLast();
            Intrinsics.checkNotNullExpressionValue(e, (String)"removeLast(...)");
            double operand2 = ((Number)e).doubleValue();
            Object e2 = stack.removeLast();
            Intrinsics.checkNotNullExpressionValue(e2, (String)"removeLast(...)");
            double operand1 = ((Number)e2).doubleValue();
            double result = switch (token) {
                case "+" -> operand1 + operand2;
                case "-" -> operand1 - operand2;
                case "*" -> operand1 * operand2;
                case "/" -> operand1 / operand2;
                case "%" -> operand1 % operand2;
                case "^" -> Math.pow(operand1, operand2);
                default -> throw new IllegalArgumentException("Unknown operator: " + token);
            };
            stack.add(result);
        }
        double result = ((Number)CollectionsKt.first((List)stack)).doubleValue();
        if (Double.isInfinite(result)) {
            return "\u221e";
        }
        if (result % 1.0 == 0.0) {
            return String.valueOf((int)result);
        }
        return String.valueOf(result);
    }

    private final boolean isDouble(String $this$isDouble) {
        return StringsKt.toDoubleOrNull((String)$this$isDouble) != null;
    }

    private static final CharSequence processMessage$lambda$0(Command this$0, MatchResult matchResult) {
        Intrinsics.checkNotNullParameter((Object)matchResult, (String)"matchResult");
        MatchGroup matchGroup = matchResult.getGroups().get(1);
        Object object = matchGroup;
        if (object == null || (object = object.getValue()) == null) {
            MatchGroup matchGroup2 = matchResult.getGroups().get(2);
            object = matchGroup2 != null ? matchGroup2.getValue() : "";
        }
        Object expression = object;
        try {
            expression = this$0.replaceVariables((String)expression);
            expression = this$0.evaluateExpression((String)expression);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (CharSequence)expression;
    }

    private static final String evaluateExpression$lambda$1(MatchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getValue();
    }
}

